#   Kriegspiel : le jeu de la guerre
#   Copyright (C) 2019  SURO François (suro@lirmm.fr)
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <https://www.gnu.org/licenses/>.


extends Node

var config

var S_Display = "DISPLAY"
var K_Width = "WIDTH"
var K_Height = "HEIGHT"
var K_Fullscreen = "FULLSCREEN"


var S_User = "USER"
var K_Language = "LANG"

func _ready():
	config = ConfigFile.new()
	var err = config.load("res://settings.cfg")
	if err == OK: # if not, something went wrong with the file loading
		print("settings.cfg loaded")
	else:
		print("settings.cfg not found, making default")
		makeDefault()
	config.save("res://settings.cfg")
	pass

func makeDefault():
	set_value(S_Display,K_Width,1024)
	set_value(S_Display,K_Height,768)
	set_value(S_Display,K_Fullscreen,false)

	set_value(S_User,K_Language,"eng")
	pass

func get_value(section, key, defaultValue):
	return config.get_value(section, key, defaultValue)
	pass

func set_value(section, key, value):
	config.set_value(section, key, value)
	pass


#func _process(delta):
#	# Called every frame. Delta is time since last frame.
#	# Update game logic here.
#	pass
