#   Kriegspiel : le jeu de la guerre
#   Copyright (C) 2019  SURO François (suro@lirmm.fr)
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <https://www.gnu.org/licenses/>.


extends Node


var lattitude = 20
var longitude = 30

var mapHandle = null

func _ready():
	# Called when the node is added to the scene for the first time.
	# Initialization here
	pass

func _readFile():

	pass

func _generateMap(path):
	print("Loading Map : " + path)
	var mapFile = ConfigFile.new()
	var err = mapFile.load(path)
	var tile
	var prevTile = null
	var line = null
	var prevLine = null
	var tileLoad = load("res://assets/tile.tscn")
	var mountainLoad = load("res://assets/mountain.tscn")
	
	lattitude = mapFile.get_value("GENERAL","LATTITUDE",20)
	longitude = mapFile.get_value("GENERAL","LONGITUDE",30)
	for lat in range(1,lattitude + 1):
		prevTile = tileLoad.instance()
		line = prevTile
		prevTile.lattitude = lat
		prevTile.longitude = 1
		for lon in range(2,longitude + 1):
			tile = tileLoad.instance()
			tile.lattitude = lat
			tile.longitude = lon
			tile.west = prevTile
			prevTile.east = tile
			prevTile = tile
		knitLines(prevLine, line)
		prevLine = line
	mapHandle = line
	while mapHandle.west:
		mapHandle = mapHandle.west
	while mapHandle.north:
		mapHandle = mapHandle.north
	
	var mountains = mapFile.get_value("MOUNTAINS","MOUNTAIN",null)
	for mnt in mountains:
		var t = getTile(mnt.x, mnt.y)
		var mt = mountainLoad.instance()
		mt.lattitude = mnt.x
		mt.longitude = mnt.y
		#mt.currentTile = t
		t.piece = mt
	pass

func knitLines(prevLine, line):
	
	if prevLine:
		while prevLine:
			line.north = prevLine
			if line.west:
				line.west.northEast = prevLine
			if line.east:
				line.east.northWest = prevLine
			prevLine.south = line
			if prevLine.west:
				prevLine.west.southEast = line
			if prevLine.east:
				prevLine.east.southWest = line
			prevLine = prevLine.east
			line = line.east
	pass

func getTile(lat, long):
	var tile = mapHandle
	while tile.lattitude != lat :
		tile = tile.south
	while tile.longitude != long :
		tile = tile.east
	return tile
	pass
	
#func _process(delta):
#	# Called every frame. Delta is time since last frame.
#	# Update game logic here.
#	pass
