#   Kriegspiel : le jeu de la guerre
#   Copyright (C) 2019  SURO François (suro@lirmm.fr)
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <https://www.gnu.org/licenses/>.


extends WorldEnvironment

const tileSize = 20

var map = null

func _ready():
	var loadMap = load("res://game/map.gd")
	map = loadMap.new()
	map._generateMap("res://maps/"+"unePartie.map")
	_displayMap()
	var cameraGroup = get_node("CameraGroup")
	cameraGroup.translate(Vector3(map.lattitude * tileSize / 2.0, 0, map.longitude * tileSize / 2.0))
	var infantryLoad = load("res://assets/infantry.tscn")
	var inf = infantryLoad.instance()
	inf.set_translation(Vector3(-tileSize*10,0,tileSize*5))
	get_node(".").call_deferred("add_child", inf)
	inf = infantryLoad.instance()
	inf.set_translation(Vector3(-tileSize*6,0,tileSize*3))
	get_node(".").call_deferred("add_child", inf)
	inf = infantryLoad.instance()
	inf.set_translation(Vector3(-tileSize*9,0,tileSize*2))
	get_node(".").call_deferred("add_child", inf)
	pass

func _displayMap():
	print("display tiles")
	var curLat = map.mapHandle
	var curLon 
	while curLat:
		curLon = curLat
		while curLon:
			curLon.set_translation(Vector3((-curLon.lattitude-1) * tileSize,0,(curLon.longitude-1) * tileSize))
			get_node(".").call_deferred("add_child", curLon)
			if curLon.piece :
				curLon.piece.set_translation(Vector3((-curLon.lattitude-1) * tileSize,0,(curLon.longitude-1) * tileSize))
				get_node(".").call_deferred("add_child", curLon.piece)
			curLon = curLon.east
		curLat = curLat.south
	pass


#func _process(delta):
#	# Called every frame. Delta is time since last frame.
#	# Update game logic here.
#	pass
