#include <termios.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <iostream>
#include <cstdlib>
#include "SuperVideoGameLibrary.h"

int kbhit(void)
{
  struct termios oldt, newt;
  int ch;
  int oldf;

  tcgetattr(STDIN_FILENO, &oldt);
  newt = oldt;
  newt.c_lflag &= ~(ICANON | ECHO);
  tcsetattr(STDIN_FILENO, TCSANOW, &newt);
  oldf = fcntl(STDIN_FILENO, F_GETFL, 0);
  fcntl(STDIN_FILENO, F_SETFL, oldf | O_NONBLOCK);

  ch = getchar();

  tcsetattr(STDIN_FILENO, TCSANOW, &oldt);
  fcntl(STDIN_FILENO, F_SETFL, oldf);

  if(ch != EOF)
  {
    ungetc(ch, stdin);
    return 1;
  }

  return 0;
}

char nonBlockingKeyInput()
{
  char ret;
  if(kbhit())
    ret = getchar();
  else
    ret = '0';
  tcflush(0,TCIFLUSH);
  return ret;
}

void sleepFunction(int microsec)
{
    usleep(microsec);
}

bool randomBooleanGeneration(double probability)
{
  return (double)rand()/(double)RAND_MAX < probability;
}

void clearScreen()
{
    system("clear");
}
